unit UnitDetails;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, StdCtrls, algorithms, multialgorithms, approxalgorithms, Common,
  Spin , math;

type
  TDetailForm = class(TForm)
    Image1: TImage;
    TBScale: TTrackBar;
    TBResolution: TTrackBar;
    Label1: TLabel;
    BtnMessen: TButton;
    TBOffset: TTrackBar;
    Label2: TLabel;
    PCSuchModus: TPageControl;
    TSMulti: TTabSheet;
    TSEinfach: TTabSheet;
    TSApprox: TTabSheet;
    Button2: TButton;
    Label3: TLabel;
    GroupBox1: TGroupBox;
    LblVarValue: TLabel;
    SE_VarValue: TSpinEdit;
    LblConstValue: TLabel;
    SE_ConstValue: TSpinEdit;
    Label8: TLabel;
    CBTextSize: TComboBox;
    Label12: TLabel;
    SEMulti_Count: TSpinEdit;
    Label18: TLabel;
    SEApproxErrorQuote: TSpinEdit;
    Label6: TLabel;
    CBModus: TComboBox;
    BtnUpdate: TButton;
    BtnSave: TButton;
    SaveDialog1: TSaveDialog;
    BtnLoad: TButton;
    OpenDialog1: TOpenDialog;
    CBLong: TCheckBox;
    SaveImageDialog: TSaveDialog;
    BtnSaveImage: TButton;
    procedure TBScaleChange(Sender: TObject);
    procedure BtnMessenClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);

    procedure CBAlgorithmsClick(Sender: TObject);
    procedure CBMultiAlgorithmsClick(Sender: TObject);
    procedure CBApproxAlgorithmsClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure PCSuchModusChanging(Sender: TObject;
      var AllowChange: Boolean);
    procedure PCSuchModusChange(Sender: TObject);
    procedure BtnUpdateClick(Sender: TObject);
    procedure CBModusChange(Sender: TObject);
    procedure BtnSaveClick(Sender: TObject);
    procedure BtnLoadClick(Sender: TObject);
    procedure BtnSaveImageClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    CBUseDetAlgorithms: Array[Searchalgorithms] of TCheckbox;
    CBMultiUseDetAlgorithms: Array[MultiSearchAlgorithms] of TCheckbox;
    CBApproxUseDetAlgorithms: Array[ApproxSearchAlgorithms] of TCheckbox;

    procedure DrawKOSystem(aBitmap: tBitmap; l,t,w,h, x,m:Integer);

    procedure InitSimpleStats(aMode: Integer; v, c: Integer; tLen: Integer);
    procedure GetSimpleStats(aMode: Integer; v, c: Integer; tLen: Integer);
    procedure StartSimpleMessung;
    procedure DrawSimpleDetails;
    procedure SimpleSave(aFilename: String);

    procedure InitMultiStats(aMode: Integer; v, c, P: Integer; tLen: Integer);
    procedure GetMultiStats(aMode: Integer; v, c, P: Integer; tLen: Integer);
    procedure StartMultiMessung;
    procedure DrawMultiDetails;
    procedure MultiSave(aFilename: String);

    procedure InitApproxStats(aMode: Integer; v, c, E: Integer; tLen: Integer);
    procedure GetApproxStats(aMode: Integer; v, c, E: Integer; tLen: Integer);
    procedure StartApproxMessung;
    procedure DrawApproxDetails;
    procedure ApproxSave(aFilename: String);
  end;


  TTimesListArray = Array of Array[SearchAlgorithms] of TList;
  TMultiTimesListArray = Array of Array[MultiSearchAlgorithms] of TList;
  TApproxTimesListArray = Array of Array[ApproxSearchAlgorithms] of TList;

  const
    MM_ConstantM = 1;
    MM_ConstantSigma = 0;

    // Neu-Definition der Farben fr die Algorithmen
    det_Colors: Array[SearchAlgorithms] of TColor
       = (
          // Prfix-Suche (4)
          clBlack, clBlack, clBlack, clBlack,
          // Suffix-Suche (4)
          clblue, clblue, clblue, clblue,
          // Faktor-Suche (3)
          clred, clred, clred,
          // Parallel (3)
          clgreen, clgreen, clgreen
       );

    SimpleFigures: Array[SearchAlgorithms] of TFigure
     = ( square, circle, triup, tridown,
         square, circle, triup, tridown,
         square,  triup, tridown,
         circle, triup, tridown
     ) ;

     det_MultiColors: Array[MultiSearchAlgorithms] of TColor
       = (
          clGreen,
          // Prfix-Suche (4)
          clBlack, clBlack, clBlack,
          clgreen,
          // Suffix-Suche
          clBlue, clBlue, clBlue,
          // Faktor-Suche
          clred
       );
       MultiFigures: Array[MultiSearchAlgorithms] of TFigure
     = ( square,
         circle, triup, tridown,
         circle,
         square,  triup, tridown,
         circle
     ) ;

     det_ApproxColors: Array[ApproxSearchAlgorithms] of TColor
       = ( clBlack, clred, clBlack, clred );
     ApproxFigures: Array[ApproxSearchAlgorithms] of TFigure
     = ( triup, triup, tridown,tridown) ;

var
  DetailForm: TDetailForm;
  //locm, locs: Integer;
  //max_M: Integer = 150;
  //max_Sigma: Integer = 150;

  Var_Max_Simple     : Integer = 150;
  Const_Value_Simple : Integer = 26;
  TextSize_Simple    : Integer = 102400;
  MessModus_Simple   : Integer = MM_ConstantSigma;

  Var_Max_Multi     : Integer = 150;
  Const_Value_Multi : Integer = 26;
  TextSize_Multi: Integer = 102400;
  MessModus_Multi: Integer = MM_ConstantSigma;

  Var_Max_Approx     : Integer = 150;
  Const_Value_Approx : Integer = 26;
  TextSize_Approx: Integer = 102400;
  MessModus_Approx: Integer = MM_ConstantSigma;

  //MessModus: Integer = MM_ConstantSigma;

  MultiCount: Integer = 10;
  ApproxError: Integer = 30;

  Average: TTimesArray;
  MultiAverage: TMultiTimesArray;
  ApproxAverage: TApproxTimesArray;

  TimesListArray: TTimesListArray;
  MultiTimesListArray: TMultiTimesListArray;
  ApproxTimesListArray: TApproxTimesListArray;

  UseDetAlgorithms: Array[Searchalgorithms] of Boolean;
  MultiUseDetAlgorithms: Array[MultiSearchalgorithms] of Boolean;
  ApproxUseDetAlgorithms: Array[ApproxSearchalgorithms] of Boolean;
  Det_GoOn : Boolean = False;

implementation

{$R *.dfm}

uses MainUnit;



procedure TDetailForm.TBScaleChange(Sender: TObject);
begin
  case PCSuchModus.ActivePageIndex of
    0:  DrawSimpleDetails;
    1:  DrawMultiDetails;
    2: DrawApproxDetails;
  end;

end;

procedure TDetailForm.DrawKOSystem(aBitmap: tBitmap; l,t,w,h,x,m: Integer);
var j, xdiv, ydiv, tx, ty, h1, h2: Integer;
    ys: String;

    function ConvertY(aValue: Integer):Integer;
    begin
       result := h - round( h / sqr(TBScale.Position) * (aValue/10 - sqr(TBOffset.Position)  ) ) + t;
    end;

    function ConvertX(aValue: Integer):Integer;
    begin
        result := Round(w / x * aValue) + l;
    end;
begin
  aBitmap.Canvas.Pen.Color := clBlack;
  aBitmap.Canvas.Font.Size := 16;

  h1 := Trunc(log10((sqr(TBScale.Position) + sqr(TBOffset.Position)))) + 1;
  h2 := Round(Power(10, h1));
  h1 := ((h2 DIV (sqr(TBScale.Position) + sqr(TBOffset.Position))) + 1);
        // Um vieviel ist die nchste 10er-Potenz grer?

  case h1 of
      0..2: h1 := 10;
      3..4: h1 := 20;
  else
      h1 := 50;
  end;

  if h2 = 0 then h2 := 1;

  if h1 <> 0 then
    yDiv := ((h2 Div h1) Div 5) * 5
  else
    ydiv := 1;

  if ydiv < 5 then ydiv := 1;

//    aBitmap.Canvas.TextOut(200,200,Inttostr(h2));
//    aBitmap.Canvas.TextOut(200,150,Inttostr(h1));

  for j := 1 to (sqr(TBScale.Position) + sqr(TBOffset.Position)) div ydiv do
  begin
    aBitmap.Canvas.MoveTo(l-5, ConvertY(j*ydiv*10));
    aBitmap.Canvas.LineTo(l-15, ConvertY(j*ydiv*10));
    if yDiv < 1000 then
      ys := Inttostr(j*yDiv)
    else
      ys := Inttostr(j*yDiv div 1000);
    tx := l - 18 - aBitmap.Canvas.TextWidth(ys);
    ty := ConvertY(j*ydiv*10) -  (aBitmap.Canvas.TextHeight(ys) Div 2);
    aBitmap.Canvas.TextOut(tx,ty, ys);
  end;

  // Zeichengedns unten (wegen Offset) lschen
  aBitmap.Canvas.FillRect(Rect(0,t + h, aBitmap.Width, aBitmap.Height ));
  aBitmap.Canvas.FillRect(Rect(0,0, aBitmap.Width, t ));
  // Achsen
  aBitmap.Canvas.MoveTo(l - 10, t);
  aBitmap.Canvas.LineTo(l - 10, t + h + 10);
  if yDiv < 1000 then
    ys := '(s)'
  else
    ys := '(ms)';
  tx := l - 18 - aBitmap.Canvas.TextWidth(ys);
  aBitmap.Canvas.TextOut(tx, t - aBitmap.Canvas.TextHeight(ys)-5, ys);

  aBitmap.Canvas.MoveTo(l - 10, t + h + 10);
  aBitmap.Canvas.LineTo(l + w, t + h + 10);

  if m = MM_ConstantSigma then
    ys := 'm'
  else
  begin
    ys :=  '|S|';
    aBitmap.Canvas.Font.Name := 'Symbol';
  end;
  ty := t+h+10 - (aBitmap.Canvas.TextHeight(ys) div 2);
  aBitmap.Canvas.TextOut(l+w+10,ty, ys);
  aBitmap.Canvas.Font.Name := 'MS Sans Serif';


  // x-Achse
  h1 := Trunc(log10(x)) + 1;
  h2 := Round(Power(10, h1));
  h1 := (h2 DIV x) + 1;
        // Um vieviel ist die nchste 10er-Potenz grer?

  case h1 of
      0..2: h1 := 10;
      3..4: h1 := 20;
  else
      h1 := 50;
  end;

 if h1 <> 0 then
    xDiv := ((h2 Div h1) Div 5) * 5
  else
    xdiv := 1;

  if xdiv < 5 then xdiv := 1;

  for j := 1 to x Div xdiv do
  begin
    aBitmap.Canvas.MoveTo(ConvertX(j * xdiv), t + h + 5);
    aBitmap.Canvas.LineTo(ConvertX(j * xdiv), t + h + 15);

    tx := ConvertX(j * xdiv) - ( aBitmap.Canvas.TextWidth(IntToStr(j*xdiv)) Div 2);
    aBitmap.Canvas.TextOut(tx,t + h + 20, IntToStr(j*xdiv) );
  end;


end;



procedure TDetailForm.InitSimpleStats(aMode: Integer; v, c: Integer; tLen: Integer);
var alg: SearchAlgorithms;
    i: Integer;
begin
  PCSuchModus.ActivePageIndex := 0;
  CBModus.ItemIndex := aMode;
  MessModus_Simple := aMode;

  Label12.Enabled := False;
  SEMulti_Count.Enabled := False;
  Label18.Enabled := False;
  SEApproxErrorQuote.Enabled := False;


  if MessModus_Simple = MM_ConstantSigma then
  begin
    Var_Max_Simple := v;
    Const_Value_Simple := c;
    LblVarValue.Caption := 'max. Musterlnge';
    LblConstValue.Caption := 'konst. Alphabetgre';
    SE_VarValue.Value := v;
    SE_ConstValue.Value := c;
  end
  else begin
    Const_Value_Simple := c;
    Var_Max_Simple := v;
    LblVarValue.Caption := 'max. Alphabetgre';
    LblConstValue.Caption := 'konst. Musterlnge';
    SE_VarValue.Value := v;
    SE_ConstValue.Value := c;
  end;

  TextSize_Simple := tlen;
  case TextSize_Simple  of
      10240     : CBTextSize.ItemIndex := 0;
      102400    : CBTextSize.ItemIndex := 1;
      1024*1024 : CBTextSize.ItemIndex := 2;
      1024*10240: CBTextSize.ItemIndex := 3;
      else        CBTextSize.ItemIndex := 4;
  end;

  for i := 0 to Length(TimesListArray)-1 do
  begin
      for alg := low(SearchAlgorithms) to high(SearchAlgorithms) do
        if assigned(TimesListArray[i,alg]) then
          FreeAndNil(TimesListArray[i,alg]);
  end;

  SetLength(TimesListArray, v + 1);
  SetLength(Average, v + 1);
  for i := 0 to Length(Average)-1 do
    for alg := low(SearchAlgorithms) to high(SearchAlgorithms) do
      Average[i,alg] := 0;

  for i := 0 to Length(TimesListArray)-1 do
      for alg := low(SearchAlgorithms) to high(SearchAlgorithms) do
          TimesListArray[i,alg] := TList.Create;

end;
procedure TDetailForm.GetSimpleStats(aMode: Integer; v, c: Integer; tLen: Integer);
var alg: SearchAlgorithms;
    im: Integer;
begin
  InitSimpleStats(aMode, v,c,tlen);
  if MessModus_Simple = MM_ConstantSigma then
  begin
    SetLength(Average, v + 1);
    for alg := low(SearchAlgorithms) to high(SearchAlgorithms) do
        for im := 1 to v do
            Average[im,alg] := Statistics[im,c,alg];
  end
  else
  begin
    SetLength(Average, v + 1);
    for alg := low(SearchAlgorithms) to high(SearchAlgorithms) do
        for im := 1 to v do
            Average[im,alg] := Statistics[c,im,alg];
  end;
end;

procedure TDetailForm.StartSimpleMessung;
var alg: SearchAlgorithms;
    im, isig: Integer;
    s,e, freq: Int64;
    done: Boolean;
    t,p: String;
begin
    QueryPerformanceFrequency(freq);
    if freq = 0 then
    begin
      freq := 1;
      MessageDlg('Genaue Zeitmessung nicht mglich. Angezeigt Werte knnen unsinnig sein.', mtWarning, [mbok], 0 );
    end;
    if MessModus_Simple = MM_ConstantSigma then
    begin
          While Det_GoOn do
          begin
         //showmessage('asas');
              t := GenerateRandomString(TextSize_Simple, Const_Value_Simple);
              for alg := low(SearchAlgorithms) to high(SearchAlgorithms) do
              begin
                  if UseDetAlgorithms[alg] then
                  begin
                      for im := 1 to Var_Max_Simple do
                      begin
                          p := GenerateRandomString(im, Const_Value_Simple);
                          QueryPerformanceCounter(s);
                          done := SimpleSearch(t,p,alg,Nil);
                          if done then
                          begin
                              QueryPerformanceCounter(e);
                              SortedInsert(TimesListArray[im,alg], Round((e-s)*10000000/freq) );
                          end;
                          if TimesListArray[im,alg].Count > 0 then
                            Average[im,alg] := GetMedian(TimesListArray[im,alg]);
                          if CBLong.Checked then
                          begin
                            DrawSimpleDetails;
                            Application.ProcessMessages;
                            if not Det_GoOn then break;
                          end;
                      end;
                      DrawSimpleDetails;
                      Application.ProcessMessages;
                      if not Det_GoOn then break;
                  end;
                  Application.ProcessMessages;
                  if not Det_GoOn then break;
              end;
          end;
    end
    else
    begin
          While Det_GoOn do
          begin
              for alg := low(SearchAlgorithms) to high(SearchAlgorithms) do
              begin
                  if UseDetAlgorithms[alg] then
                  begin
                      for isig := 2 to Var_Max_Simple do
                      begin
                          t := GenerateRandomString(TextSize_Simple, isig);
                          p := GenerateRandomString(Const_Value_Simple, isig);
                          QueryPerformanceCounter(s);
                          done := SimpleSearch(t,p,alg,Nil);
                          if done then
                          begin
                              QueryPerformanceCounter(e);
                              SortedInsert(TimesListArray[isig,alg], Round((e-s)*10000000/freq) );
                          end;
                          if TimesListArray[isig,alg].Count > 0 then
                            Average[isig,alg] := GetMedian(TimesListArray[isig,alg]);
                          if CBLong.Checked then
                          begin
                            DrawSimpleDetails;
                            Application.ProcessMessages;
                            if not Det_GoOn then break;
                          end;
                      end;
                      DrawSimpleDetails;
                      Application.ProcessMessages;
                      if not Det_GoOn then break;
                  end;
                  Application.ProcessMessages;
                  if not Det_GoOn then break;
              end;
          end;

    end;
end;


procedure TDetailForm.DrawSimpleDetails;
var aBitmap: TBitmap;
    // Grenzen des eigentlichen Zeichenbereichs auf dem Bitmap
    mainleft, maintop, mainheight, mainwidth: Integer;
    im: Integer;
    alg: SearchAlgorithms;
    MainCount: Integer;

    function ConvertY(aValue: Integer):Integer;
    begin
       result := MainHeight - round( MainHeight / sqr(TBScale.Position) * (aValue/10 - sqr(TBOffset.Position)  ) ) + mainTop;
    end;

    function ConvertX(aValue: Integer):Integer;
    begin
        result := Round(mainwidth / Var_Max_Simple * aValue) + mainLeft;
    end;
begin
  aBitmap := TBitmap.Create;
  aBitmap.Width := IMage1.Width;
  aBitmap.Height := Image1.Height;

  mainleft := 60;
  maintop := 40;
  mainheight := aBitmap.Height - 80;
  mainwidth := aBitmap.Width - 100;

      for alg := low(SearchAlgorithms) to high(SearchAlgorithms) do
      begin
          if UseDetAlgorithms[alg] then
          begin
              MainCount := 0;
              //if Colors[alg] <> clWhite then
                aBitmap.Canvas.Pen.Color := det_Colors[alg];
              //else
              //  aBitmap.Canvas.Pen.Color := clBlack;
              // Eine Zeile zeichnen, also fr alle m
              im := MessModus_Simple + 1;  //  m geht bei 1 los, sigma bei 2
              aBitmap.Canvas.MoveTo(ConvertX(im), ConvertY(Average[im,alg]) );
              while im <= Var_Max_Simple {-TBResolution.Position} do
              begin
                  if Average[im,alg] <> 0 then
                  begin
                      aBitmap.Canvas.LineTo(ConvertX(im), ConvertY(Average[im,alg]));
                      //if (Maincount Mod (Integer(alg)+1)) = (0) then
                      If (Maincount Mod 13) = (5* Integer(alg) mod 13) then
                      DrawDot(aBitmap.Canvas,  ConvertX(im), ConvertY(Average[im,alg]),
                        SimpleFigures[alg], det_Colors[alg]);
                  end;
                  inc(im, TBResolution.Position);
                  inc(MainCount);
              end;
          end;
      end;
      // Koordinatensystem zeichnen
      DrawKOSystem(aBitmap, MainLeft, MainTop, MainWidth, MainHeight, Var_Max_Simple, MessModus_Simple);

  Image1.Picture.Bitmap.Assign(aBitmap);
  aBitmap.Free;
end;

procedure TDetailForm.SimpleSave(aFilename: String);
var stream: TMemoryStream;
    i,l,  h: Integer;
    alg: SearchAlgorithms;
begin
  stream := TMemoryStream.Create;
  //Stream.Size := nicht so einfach berechenbar
  h := 100; // einfache Suche
  Stream.Write(h, SizeOf(Integer));

  Stream.Write(MessModus_Simple, SizeOf(Integer));
  Stream.Write(Var_Max_Simple    , SizeOf(Integer));
  Stream.Write(Const_Value_Simple, SizeOf(Integer));
  Stream.Write(TextSize_Simple, SizeOf(Integer));
  for alg := low(SearchAlgorithms) to high(SearchAlgorithms) do
  begin
    for i := 1 to Var_Max_Simple do
    begin
        Stream.Write( TimesListArray[i,alg].Count, SizeOf(Integer));
        for l :=0 to TimesListArray[i,alg].Count - 1 do
        begin
          h := Integer(TimesListArray[i,alg][l]);
          Stream.Write( h, SizeOf(Integer));
        end;
    end;
  end;
  Stream.SaveToFile(aFilename);
end;

procedure TDetailForm.InitMultiStats(aMode: Integer; v, c, P: Integer; tLen: Integer);
var alg: MultiSearchAlgorithms;
    i: Integer;
begin
  PCSuchModus.ActivePageIndex := 1;
  CBModus.ItemIndex := aMode;
  MessModus_Multi := aMode;

  SEMulti_Count.Value := P;
  MultiCount := P;

  Label12.Enabled := True;
  SEMulti_Count.Enabled := True;
  Label18.Enabled := False;
  SEApproxErrorQuote.Enabled := False;

  if MessModus_Multi = MM_ConstantSigma then
  begin
    Var_Max_Multi := v;
    Const_Value_Multi := c;
    LblVarValue.Caption := 'max. Musterlnge';
    LblConstValue.Caption := 'konst. Alphabetgre';
    SE_VarValue.Value := v;
    SE_ConstValue.Value := c;
  end
  else begin
    Const_Value_Multi := c;
    Var_Max_Multi := v;
    LblVarValue.Caption := 'max. Alphabetgre';
    LblConstValue.Caption := 'konst. Musterlnge';
    SE_VarValue.Value := v;
    SE_ConstValue.Value := c;
  end;

  TextSize_Multi := tlen;
  case TextSize_Multi  of
      10240     : CBTextSize.ItemIndex := 0;
      102400    : CBTextSize.ItemIndex := 1;
      1024*1024 : CBTextSize.ItemIndex := 2;
      1024*10240: CBTextSize.ItemIndex := 3;
      else        CBTextSize.ItemIndex := 4;
  end;

  for i := 0 to Length(MultiTimesListArray)-1 do
  begin
      for alg := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
        if assigned(MultiTimesListArray[i,alg]) then
          FreeAndNil(MultiTimesListArray[i,alg]);
  end;

  SetLength(MultiTimesListArray, v + 1);
  SetLength(MultiAverage, v + 1);
  for i := 0 to Length(MultiAverage)-1 do
    for alg := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
      MultiAverage[i,alg] := 0;
  
  for i := 0 to Length(MultiTimesListArray)-1 do
      for alg := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
          MultiTimesListArray[i,alg] := TList.Create;

end;

procedure TDetailForm.GetMultiStats(aMode: Integer; v, c, P: Integer; tLen: Integer);
var alg: MultiSearchAlgorithms;
    im: Integer;
begin
  InitMultiStats(aMode, v, c, P, tLen);
  if MessModus_Multi = MM_ConstantSigma then
  begin
    SetLength(MultiAverage, v + 1);
    for alg := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
        for im := 1 to v do
            MultiAverage[im,alg] := MultiStatistics[im,c,alg];
  end
  else
  begin
    SetLength(MultiAverage, v + 1);
    for alg := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
        for im := 1 to v do
            MultiAverage[im,alg] := MultiStatistics[c,im,alg];
  end;
end;

procedure TDetailForm.StartMultiMessung;
var alg: MultiSearchAlgorithms;
    im, isig, pc: Integer;
    s,e, freq: Int64;
    done: Boolean;
    t: String;
    p: TStrings;
begin
    QueryPerformanceFrequency(freq);
    if freq = 0 then
    begin
      freq := 1;
      MessageDlg('Genaue Zeitmessung nicht mglich. Angezeigt Werte knnen unsinnig sein.', mtWarning, [mbok], 0 );
    end;

    P := TStringlist.Create;
    P.Capacity := MultiCount;
    for im := 0 to MultiCount-1 do
      P.Add('');


    if MessModus_Multi = MM_ConstantSigma then
    begin
          While Det_GoOn do
          begin
         //showmessage('asas');
              t := GenerateRandomString(TextSize_Multi, Const_Value_Multi);
              for alg := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
              begin
                  if MultiUseDetAlgorithms[alg] then
                  begin
                      for im := 1 to Var_Max_Multi do
                      begin
                          for pc := 0 to P.Count-1 do
                              P[pc] := GenerateRandomString(im, Const_Value_Multi);

                          QueryPerformanceCounter(s);
                          done := MultiSearch(t,p,alg,Nil);
                          if done then
                          begin
                              QueryPerformanceCounter(e);
                              SortedInsert(MultiTimesListArray[im,alg], Round((e-s)*10000000/freq) );
                          end;
                          if MultiTimesListArray[im,alg].Count > 0 then
                            MultiAverage[im,alg] := GetMedian(MultiTimesListArray[im,alg]);
                          if CBLong.Checked then
                          begin
                            DrawMultiDetails;
                            Application.ProcessMessages;
                            if not Det_GoOn then break;
                          end;
                      end;
                      DrawMultiDetails;
                      Application.ProcessMessages;
                      if not Det_GoOn then break;
                  end;
                  Application.ProcessMessages;
                  if not Det_GoOn then break;
              end;
          end;
    end
    else
    begin
          While Det_GoOn do
          begin
              for alg := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
              begin
                  if MultiUseDetAlgorithms[alg] then
                  begin
                      for isig := 2 to Var_Max_Multi do
                      begin
                          t := GenerateRandomString(TextSize_Multi, isig);
                          for pc := 0 to P.Count-1 do
                              P[pc] := GenerateRandomString(Const_Value_Multi, iSig);
                          QueryPerformanceCounter(s);
                          done := MultiSearch(t,p,alg,Nil);
                          if done then
                          begin
                              QueryPerformanceCounter(e);
                              SortedInsert(MultiTimesListArray[isig,alg], Round((e-s)*10000000/freq) );
                          end;
                          if MultiTimesListArray[isig,alg].Count > 0 then
                            MultiAverage[isig,alg] := GetMedian(MultiTimesListArray[isig,alg]);
                          if CBLong.Checked then
                          begin
                            DrawMultiDetails;
                            Application.ProcessMessages;
                            if not Det_GoOn then break;
                          end;
                      end;
                      DrawMultiDetails;
                      Application.ProcessMessages;
                      if not Det_GoOn then break;
                  end;
                  Application.ProcessMessages;
                  if not Det_GoOn then break;
              end;
          end;

    end;
end;
procedure TDetailForm.DrawMultiDetails;
var aBitmap: TBitmap;
    // Grenzen des eigentlichen Zeichenbereichs auf dem Bitmap
    mainleft, maintop, mainheight, mainwidth: Integer;
    im, MainCount: Integer;
    alg: MultiSearchAlgorithms;

    function ConvertY(aValue: Cardinal):Cardinal;
    begin
       result := MainHeight - round( MainHeight / sqr(TBScale.Position) * (aValue/10 - sqr(TBOffset.Position)  ) ) + mainTop;
    end;

    function ConvertX(aValue: Integer):Integer;
    begin
        result := Round(mainwidth / Var_Max_Multi * aValue) + mainLeft;
    end;
begin
  aBitmap := TBitmap.Create;
  aBitmap.Width := IMage1.Width;
  aBitmap.Height := Image1.Height;

  mainleft := 60;
  maintop := 40;
  mainheight := aBitmap.Height - 80;
  mainwidth := aBitmap.Width - 100;



      for alg := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
      begin
          if MultiUseDetAlgorithms[alg] then
          begin
              MainCount := 0;
              //if MultiColors[alg] <> clWhite then
                aBitmap.Canvas.Pen.Color := det_MultiColors[alg];
              //else
              //  aBitmap.Canvas.Pen.Color := clBlack;
              // Eine Zeile zeichnen, also fr alle m


              im := MessModus_Multi + 1;


              aBitmap.Canvas.MoveTo(ConvertX(im), ConvertY(MultiAverage[im,alg]) );
              while im <= Var_Max_Multi {-TBResolution.Position} do
              begin
                  if MultiAverage[im,alg] <> 0 then
                  begin
                      aBitmap.Canvas.LineTo(ConvertX(im), ConvertY(MultiAverage[im,alg]));
                      If (Maincount Mod 13) = (5* Integer(alg) mod 13) then
                      DrawDot(aBitmap.Canvas,  ConvertX(im), ConvertY(MultiAverage[im,alg]),
                        MultiFigures[alg], det_MultiColors[alg]);
                  end;
                  inc(im, TBResolution.Position);
                  inc(MainCount);
              end;
          end;
      end;
      // Koordinatensystem zeichnen
      DrawKOSystem(aBitmap, MainLeft, MainTop, MainWidth, MainHeight, Var_Max_Multi, MessModus_Multi);
  Image1.Picture.Bitmap.Assign(aBitmap);
  aBitmap.Free;
end;

procedure TDetailForm.MultiSave(aFilename: String);
var stream: TMemoryStream;
    i,l,  h: Integer;
    alg: MultiSearchAlgorithms;
begin
  stream := TMemoryStream.Create;
  //Stream.Size := nicht so einfach berechenbar
  h := 101; // Multi Suche
  Stream.Write(h, SizeOf(Integer));

  Stream.Write(MessModus_Multi, SizeOf(Integer));
  Stream.Write(Var_Max_Multi    , SizeOf(Integer));
  Stream.Write(Const_Value_Multi, SizeOf(Integer));
  Stream.Write(TextSize_Multi, SizeOf(Integer));
  Stream.Write(MultiCount, SizeOf(Integer));
  for alg := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
  begin
    for i := 1 to Var_Max_Multi do
    begin
        Stream.Write( MultiTimesListArray[i,alg].Count, SizeOf(Integer));
        for l :=0 to MultiTimesListArray[i,alg].Count - 1 do
        begin
          h := Integer(MultiTimesListArray[i,alg][l]);
          Stream.Write( h, SizeOf(Integer));
        end;
    end;
  end;
  Stream.SaveToFile(aFilename);
end;

procedure TDetailForm.InitApproxStats(aMode: Integer; v, c, E: Integer; tLen: Integer);
var alg: ApproxSearchAlgorithms;
    i: Integer;
begin
  PCSuchModus.ActivePageIndex := 2;
  CBModus.ItemIndex := aMode;
  MessModus_Approx := aMode;

  Label12.Enabled := False;
  SEMulti_Count.Enabled := False;
  Label18.Enabled := True;
  SEApproxErrorQuote.Enabled := True;
  SEApproxErrorQuote.Value := E;
  ApproxError := E;


  if MessModus_Approx = MM_ConstantSigma then
  begin
    Var_Max_Approx := v;
    Const_Value_Approx := c;
    LblVarValue.Caption := 'max. Musterlnge';
    LblConstValue.Caption := 'konst. Alphabetgre';
    SE_VarValue.Value := v;
    SE_ConstValue.Value := c;
  end
  else begin
    Const_Value_Approx := c;
    Var_Max_Approx := v;
    LblVarValue.Caption := 'max. Alphabetgre';
    LblConstValue.Caption := 'konst. Musterlnge';
    SE_VarValue.Value := v;
    SE_ConstValue.Value := c;
  end;

  TextSize_Approx := tlen;
  case TextSize_Approx  of
      10240     : CBTextSize.ItemIndex := 0;
      102400    : CBTextSize.ItemIndex := 1;
      1024*1024 : CBTextSize.ItemIndex := 2;
      1024*10240: CBTextSize.ItemIndex := 3;
      else        CBTextSize.ItemIndex := 4;
  end;

  for i := 0 to Length(ApproxTimesListArray)-1 do
  begin
      for alg := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
        if assigned(ApproxTimesListArray[i,alg]) then
          FreeAndNil(ApproxTimesListArray[i,alg]);
  end;

  SetLength(ApproxTimesListArray, v + 1);
  SetLength(ApproxAverage, v + 1);
  for i := 0 to Length(ApproxAverage)-1 do
    for alg := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
      ApproxAverage[i,alg] := 0;

  for i := 0 to Length(ApproxTimesListArray)-1 do
      for alg := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
          ApproxTimesListArray[i,alg] := TList.Create;
end;
procedure TDetailForm.GetApproxStats(aMode: Integer; v, c, E: Integer; tLen: Integer);
var alg: ApproxSearchAlgorithms;
    im: Integer;
begin
  InitApproxStats(aMode, v, c, E, tLen);
  if MessModus_Approx = MM_ConstantSigma then
  begin
    SetLength(ApproxAverage, v + 1);
    for alg := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
        for im := 1 to v do
            ApproxAverage[im,alg] := ApproxStatistics[im,c,alg];
  end
  else
  begin
    SetLength(ApproxAverage, v + 1);
    for alg := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
        for im := 1 to v do
            ApproxAverage[im,alg] := ApproxStatistics[c,im,alg];
  end;
end;
procedure TDetailForm.StartApproxMessung;
var alg: ApproxSearchAlgorithms;
    im, isig: Integer;
    s,e, freq: Int64;
    done: Boolean;
    t,p: String;
begin
    QueryPerformanceFrequency(freq);
    if freq = 0 then
    begin
      freq := 1;
      MessageDlg('Genaue Zeitmessung nicht mglich. Angezeigt Werte knnen unsinnig sein.', mtWarning, [mbok], 0 );
    end;
    if MessModus_Approx = MM_ConstantSigma then
    begin
          While Det_GoOn do
          begin
              t := GenerateRandomString(TextSize_Approx, Const_Value_Approx);
              for alg := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
              begin
                  if ApproxUseDetAlgorithms[alg] then
                  begin
                      for im := 1 to Var_Max_Approx do
                      begin
                          p := GenerateRandomString(im, Const_Value_Approx);
                          QueryPerformanceCounter(s);
                          done := ApproxSearch(t,p,ApproxError,alg,Nil, EM_RELATIVE);
                          if done then
                          begin
                              QueryPerformanceCounter(e);
                              SortedInsert(ApproxTimesListArray[im,alg], Round((e-s)*10000000/freq) );
                          end;
                          if ApproxTimesListArray[im,alg].Count > 0 then
                            ApproxAverage[im,alg] := GetMedian(ApproxTimesListArray[im,alg]);
                          if CBLong.Checked then
                          begin
                            DrawApproxDetails;
                            Application.ProcessMessages;
                            if not Det_GoOn then break;
                          end;
                      end;
                      DrawApproxDetails;
                      Application.ProcessMessages;
                      if not Det_GoOn then break;
                  end;
                  Application.ProcessMessages;
                  if not Det_GoOn then break;
              end;
          end;
    end
    else
    begin
          While Det_GoOn do
          begin
              for alg := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
              begin
                  if ApproxUseDetAlgorithms[alg] then
                  begin
                      for isig := 2 to Var_Max_Approx do
                      begin
                          t := GenerateRandomString(TextSize_Approx, isig);
                          p := GenerateRandomString(Const_Value_Approx, isig);
                          QueryPerformanceCounter(s);
                          done := ApproxSearch(t,p,ApproxError,alg,Nil,EM_RELATIVE);
                          if done then
                          begin
                              QueryPerformanceCounter(e);
                              SortedInsert(ApproxTimesListArray[isig,alg], Round((e-s)*10000000/freq) );
                          end;
                          if ApproxTimesListArray[isig,alg].Count > 0 then
                            ApproxAverage[isig,alg] := GetMedian(ApproxTimesListArray[isig,alg]);
                          if CBLong.Checked then
                          begin
                            DrawApproxDetails;
                            Application.ProcessMessages;
                            if not Det_GoOn then break;
                          end;
                      end;
                      DrawApproxDetails;
                      Application.ProcessMessages;
                      if not Det_GoOn then break;
                  end;
                  Application.ProcessMessages;
                  if not Det_GoOn then break;
              end;
          end;

    end;
end;
procedure TDetailForm.DrawApproxDetails;
var aBitmap: TBitmap;
    // Grenzen des eigentlichen Zeichenbereichs auf dem Bitmap
    mainleft, maintop, mainheight, mainwidth: Integer;
    im, MainCount: Integer;
    alg: ApproxSearchAlgorithms;

    function ConvertY(aValue: Integer):Integer;
    begin
       result := MainHeight - round( MainHeight / sqr(TBScale.Position) * (aValue/10 - sqr(TBOffset.Position)  ) ) + mainTop;
    end;

    function ConvertX(aValue: Integer):Integer;
    begin
        result := Round(mainwidth / Var_Max_Approx * aValue) + mainLeft;
    end;
begin
  aBitmap := TBitmap.Create;
  aBitmap.Width := IMage1.Width;
  aBitmap.Height := Image1.Height;

  mainleft := 60;
  maintop := 40;
  mainheight := aBitmap.Height - 80;
  mainwidth := aBitmap.Width - 100;

      for alg := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
      begin
          if ApproxUseDetAlgorithms[alg] then
          begin
              MainCount := 0;
              //if ApproxColors[alg] <> clWhite then
                aBitmap.Canvas.Pen.Color := det_ApproxColors[alg];
              //else
              //  aBitmap.Canvas.Pen.Color := clBlack;
              // Eine Zeile zeichnen, also fr alle m
              im := MessModus_Approx + 1;
              aBitmap.Canvas.MoveTo(ConvertX(im), ConvertY(ApproxAverage[im,alg]) );
              while im <= Var_Max_Approx {-TBResolution.Position} do
              begin
                  if ApproxAverage[im,alg] <> 0 then
                  begin
                      aBitmap.Canvas.LineTo(ConvertX(im), ConvertY(ApproxAverage[im,alg]));
                      If (Maincount Mod 7) = (3* Integer(alg) mod 7) then
                      DrawDot(aBitmap.Canvas,  ConvertX(im), ConvertY(ApproxAverage[im,alg]),
                        ApproxFigures[alg], det_ApproxColors[alg]);
                  end;
                  inc(im, TBResolution.Position);
                  inc(MainCount);
              end;
          end;
      end;
      // Koordinatensystem zeichnen
      DrawKOSystem(aBitmap, MainLeft, MainTop, MainWidth, MainHeight, Var_Max_Approx, MessModus_Approx);
  Image1.Picture.Bitmap.Assign(aBitmap);
  aBitmap.Free;
end;

procedure TDetailForm.ApproxSave(aFilename: String);
var stream: TMemoryStream;
    i,l,  h: Integer;
    alg: ApproxSearchAlgorithms;
begin
  stream := TMemoryStream.Create;
  //Stream.Size := nicht so einfach berechenbar
  h := 102; // einfache Suche
  Stream.Write(h, SizeOf(Integer));

  Stream.Write(MessModus_Approx, SizeOf(Integer));
  Stream.Write(Var_Max_Approx    , SizeOf(Integer));
  Stream.Write(Const_Value_Approx, SizeOf(Integer));
  Stream.Write(TextSize_Approx, SizeOf(Integer));
  Stream.Write(ApproxError, SizeOf(Integer));
  for alg := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
  begin
    for i := 1 to Var_Max_Approx do
    begin
        Stream.Write( ApproxTimesListArray[i,alg].Count, SizeOf(Integer));
        for l :=0 to ApproxTimesListArray[i,alg].Count - 1 do
        begin
          h := Integer(ApproxTimesListArray[i,alg][l]);
          Stream.Write( h, SizeOf(Integer));
        end;
    end;
  end;
  Stream.SaveToFile(aFilename);
end;

procedure TDetailForm.BtnMessenClick(Sender: TObject);
begin
    Det_GoOn := True;
    case PCSuchModus.ActivePageIndex of
      0: StartSimpleMessung;
      1: StartMultiMessung;
      2: StartApproxMessung;
    end;
    Det_GoOn := False;
end;

procedure TDetailForm.CBAlgorithmsClick(Sender: TObject);
begin
 // if Suchmodus <> 0 then exit;
  UseDetAlgorithms[SearchAlgorithms((Sender as TCheckbox).Tag)] := (Sender as TCheckbox).Checked;
  DrawSimpleDetails;
end;

procedure TDetailForm.CBMultiAlgorithmsClick(Sender: TObject);
begin
 // if Suchmodus <> 1 then exit;
  MultiUseDetAlgorithms[MultiSearchAlgorithms((Sender as TCheckbox).Tag)] := (Sender as TCheckbox).Checked;
  DrawMultiDetails;
end;

procedure TDetailForm.CBApproxAlgorithmsClick(Sender: TObject);
begin
  //if Suchmodus <> 2 then exit;
  ApproxUseDetAlgorithms[ApproxSearchAlgorithms((Sender as TCheckbox).Tag)] := (Sender as TCheckbox).Checked;
  DrawApproxDetails;
end;

procedure TDetailForm.FormCreate(Sender: TObject);
var a: SearchAlgorithms;
  am: MultiSearchAlgorithms;
  ap: ApproxSearchAlgorithms;
  NewImage: TImage;
  abmp: TBitmap;
  NewCheckbox: TCheckBox;
begin
  abmp := TBitmap.Create;
  aBmp.Width := 20;
  aBmp.Height := 20;
  aBmp.Canvas.Brush.Color := clBtnFace;
  aBmp.Canvas.Pen.Color := clBtnFace;
// Legende Initialisieren - Shapes erstellen
  for a := Low(SearchAlgorithms) to High(SearchAlgorithms) do
  begin

    aBmp.Canvas.Brush.Color := clBtnFace;
    aBmp.Canvas.Pen.Color := clBtnFace;

    NewImage := TImage.Create(Self);
    NewImage.Parent := TSEinfach;
    NewImage.Left := 16;
    NewImage.Top := (Integer(a) + 1) * 24 - 16;
    NewImage.Width := 20;
    NewImage.Height := 20;
    aBmp.Canvas.Rectangle(0,0,20,20);
    aBmp.Canvas.Pen.Color := det_Colors[a];
    aBmp.Canvas.MoveTo(0,10);
    aBmp.Canvas.LineTo(20,10);
    DrawDot(aBmp.Canvas, 10,10, SimpleFigures[a], det_Colors[a] );
    aBmp.Canvas.Pen.Color := clBtnFace;

    aBmp.Canvas.Pen.Color := clWhite;
    NewImage.Picture.Bitmap.Assign(aBmp);
    NewCheckbox := TCheckBox.Create(Self);
    NewCheckbox.Parent := TSEinfach;
    NewCheckbox.Top := 28 + Integer(a) * 24  - 16;
    NewCheckbox.Left := 40;
    NewCheckbox.Width := 190;
    NewCheckbox.Caption := AlgorithmNames[a];
    NewCheckbox.Tag := Integer(a);
    NewCheckBox.Checked := True;
    NewCheckBox.OnClick := CBAlgorithmsClick;
    UseDetAlgorithms[a] := True;
    CBUseDetAlgorithms[a] := NewCheckbox;
  end;
  aBmp.Canvas.Pen.Color := clBtnFace;
  for am := Low(MultiSearchAlgorithms) to High(MultiSearchAlgorithms) do
  begin
    NewImage := TImage.Create(Self);
    NewImage.Parent := TSMulti;
    NewImage.Left := 16;
    NewImage.Top := (Integer(am) + 1) * 24 - 16;
    NewImage.Width := 20;
    NewImage.Height := 20;

    aBmp.Canvas.Rectangle(0,0,20,20);
    aBmp.Canvas.Pen.Color := det_MultiColors[am];
    aBmp.Canvas.MoveTo(0,10);
    aBmp.Canvas.LineTo(20,10);
    DrawDot(aBmp.Canvas, 10,10, MultiFigures[am], det_MultiColors[am] );
    aBmp.Canvas.Pen.Color := clBtnFace;

    NewImage.Picture.Bitmap.Assign(aBmp);
    NewCheckbox := TCheckBox.Create(Self);
    NewCheckbox.Parent := TSMulti;
    NewCheckbox.Top := 28 + Integer(am) * 24 - 16;
    NewCheckbox.Left := 40;
    NewCheckbox.Width := 190;
    NewCheckbox.Caption := MultiAlgorithmNames[am];
    NewCheckbox.Tag := Integer(am);
    NewCheckBox.Checked := True;
    NewCheckBox.OnClick := CBMultiAlgorithmsClick;
    MultiUseDetAlgorithms[am] := True;
    CBMultiUseDetAlgorithms[am] := NewCheckbox;
  end;
  aBmp.Canvas.Pen.Color := clBtnFace;
  for ap := Low(ApproxSearchAlgorithms) to High(ApproxSearchAlgorithms) do
  begin
    NewImage := TImage.Create(Self);
    NewImage.Parent := TSApprox;
    NewImage.Left := 16;
    NewImage.Top := (Integer(ap) + 1) * 24 - 16;
    NewImage.Width := 20;
    NewImage.Height := 20;

    aBmp.Canvas.Rectangle(0,0,20,20);
    aBmp.Canvas.Pen.Color := det_ApproxColors[ap];
    aBmp.Canvas.MoveTo(0,10);
    aBmp.Canvas.LineTo(20,10);
    DrawDot(aBmp.Canvas, 10,10, ApproxFigures[ap], det_ApproxColors[ap] );
    aBmp.Canvas.Pen.Color := clBtnFace;
    NewImage.Picture.Bitmap.Assign(aBmp);


    {aBMP.SaveToFile(ExtractFilePath(ParamStr(0)) + 'Daten\Legende\det_approx_' + ApproxAlgorithmNames[ap] + '.bmp');
    aBmp.Canvas.Brush.Color := ApproxColors[ap];
    aBmp.Canvas.Pen.Color := clBlack;
    aBmp.Canvas.Rectangle(0,0,20,20);
    aBMP.SaveToFile(ExtractFilePath(ParamStr(0)) + 'Daten\Legende\approx_' + ApproxAlgorithmNames[ap] + '.bmp');
}
    NewCheckbox := TCheckBox.Create(Self);
    NewCheckbox.Parent := TSApprox;
    NewCheckbox.Top := 28 + Integer(ap) * 24 - 16;
    NewCheckbox.Left := 40;
    NewCheckbox.Width := 190;
    NewCheckbox.Caption := ApproxAlgorithmNames[ap];
    NewCheckbox.Tag := Integer(ap);
    NewCheckBox.Checked := True;
    NewCheckBox.OnClick := CBApproxAlgorithmsClick;
    ApproxUseDetAlgorithms[ap] := True;
    CBApproxUseDetAlgorithms[ap] := NewCheckbox;
  end;
  aBmp.Free;

  InitApproxStats(0, Var_Max_Approx, Const_Value_Approx, ApproxError, TextSize_Approx);
  InitMultiStats (0, Var_Max_Multi,  Const_Value_Multi,  MultiCount, TextSize_Multi);
  InitSimpleStats(0, Var_Max_Simple, Const_Value_Simple, TextSize_Simple);
  
  PCSuchModus.ActivePageIndex := 0;
end;

procedure TDetailForm.Button2Click(Sender: TObject);
begin
  Det_GoOn := False;
end;

procedure TDetailForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Det_GoOn := False;
end;

procedure TDetailForm.PCSuchModusChanging(Sender: TObject;
  var AllowChange: Boolean);
begin
  AllowChange := Not Det_GoOn;
end;

procedure TDetailForm.PCSuchModusChange(Sender: TObject);
    function TextSizeToIndex(aValue: Integer): Integer;
    begin
        case aValue  of
            10240     : result := 0;
            102400    : result := 1;
            1024*1024 : result := 2;
            1024*10240: result := 3;
            else        result := 4;
        end;
    end;
begin
    case PCSuchModus.ActivePageIndex of
      0: begin
          CBModus.ItemIndex    :=  MessModus_Simple   ;
          SE_VarValue.Value    :=  Var_Max_Simple     ;
          SE_ConstValue.Value  :=  Const_Value_Simple ;
          CBTextSize.ItemIndex :=  TextSizeToIndex(TextSize_Simple);

          DrawSimpleDetails;
      end;
      1: begin
          CBModus.ItemIndex    :=  MessModus_Multi   ;
          SE_VarValue.Value    :=  Var_Max_Multi     ;
          SE_ConstValue.Value  :=  Const_Value_Multi ;
          CBTextSize.ItemIndex :=  TextSizeToIndex(TextSize_Multi);
          SEMulti_Count.Value  :=  MultiCount;
          DrawMultiDetails;
      end;
      2: begin
          CBModus.ItemIndex    :=  MessModus_Approx   ;
          SE_VarValue.Value    :=  Var_Max_Approx     ;
          SE_ConstValue.Value  :=  Const_Value_Approx ;
          CBTextSize.ItemIndex :=  TextSizeToIndex(TextSize_Approx);
          SEApproxErrorQuote.Value  :=  ApproxError;
          DrawApproxDetails;
      end;
    end;
    Label12.Enabled       := PCSuchModus.ActivePageIndex = 1;
    SEMulti_Count.Enabled := PCSuchModus.ActivePageIndex = 1;

    Label18.Enabled            := PCSuchModus.ActivePageIndex = 2;
    SEApproxErrorQuote.Enabled := PCSuchModus.ActivePageIndex = 2;
end;

procedure TDetailForm.BtnUpdateClick(Sender: TObject);
var tmp: Integer;
begin
  Det_GoOn := False;
  case CBTextSize.ItemIndex of
    0: tmp := 10240;
    1: tmp := 102400;
    2: tmp := 1024*1024;
    3: tmp := 1024*10240;
    else tmp := 1024*10240*5;
  end;

  case PCSuchModus.ActivePageIndex of
      0: begin
          Var_Max_Simple     := SE_VarValue.Value;
          Const_Value_Simple := SE_ConstValue.Value;
          TextSize_Simple := tmp;
          MessModus_Simple := CBModus.ItemIndex;
          InitSimpleStats(MessModus_Simple, Var_Max_Simple, Const_Value_Simple, TextSize_Simple);
          DrawSimpleDetails;
      end;
      1: begin
          Var_Max_Multi     := SE_VarValue.Value;
          Const_Value_Multi := SE_ConstValue.Value;
          MultiCount := SEMulti_Count.Value;
          TextSize_Multi := tmp;
          MessModus_Multi := CBModus.ItemIndex;
          InitMultiStats(MessModus_Multi, Var_Max_Multi, Const_Value_Multi, MultiCount, TextSize_Multi);
          DrawMultiDetails;
      end;
      2: begin
          Var_Max_Approx     := SE_VarValue.Value;
          Const_Value_Approx := SE_ConstValue.Value;
          ApproxError := SEApproxErrorQuote.Value;
          TextSize_Approx := tmp;
          MessModus_Approx := CBModus.ItemIndex;
          InitApproxStats(MessModus_Approx, Var_Max_Approx, Const_Value_Approx, ApproxError, TextSize_Approx);
          DrawApproxDetails;
      end;
    end;
end;

procedure TDetailForm.CBModusChange(Sender: TObject);
begin
  case CBModus.ItemIndex of
    0: begin
        LblVarValue.Caption := 'max. Musterlnge';
        LblConstValue.Caption := 'konst. Alphabetgre';
      end;
    1: begin
        LblVarValue.Caption := 'max. Alphabetgre';
        LblConstValue.Caption := 'konst. Musterlnge';
    end;
  end;
end;

procedure TDetailForm.BtnSaveClick(Sender: TObject);
begin
  case PCSuchModus.ActivePageIndex of
        0: begin
            If Messmodus_Simple = MM_ConstantSigma then
               SaveDialog1.FileName :=  Format('Details_Einfach_Sigma_konstant_%d_MMax_%d_Text_%s.det'
                      , [Const_Value_Simple, Var_Max_Simple, TextSizeToFilename(TextSize_Simple) ])
            else
               SaveDialog1.FileName :=  Format('Details_Einfach_M_konstant_%d_SigmaMax_%d_Text_%s.det'
                      , [Const_Value_Simple, Var_Max_Simple, TextSizeToFilename(TextSize_Simple) ]);
            if SaveDialog1.Execute then
              SimpleSave(SaveDialog1.Filename);
        end;
        1: begin
            If Messmodus_Multi = MM_ConstantSigma then
               SaveDialog1.FileName :=  Format('Details_Multi_Sigma_konstant_%d_MMax_%d_Anzahl_%d_Text_%s.det'
                      , [Const_Value_Multi, Var_Max_Multi, MultiCount, TextSizeToFilename(TextSize_Multi) ])
            else
               SaveDialog1.FileName :=  Format('Details_Multi_M_konstant_%d_SigmaMax_%d_Anzahl_%d_Text_%s.det'
                      , [Const_Value_Multi, Var_Max_Multi, MultiCount ,TextSizeToFilename(TextSize_Multi) ]);
            if SaveDialog1.Execute then
              MultiSave(SaveDialog1.Filename);
        end;
        2: begin
            If Messmodus_Approx = MM_ConstantSigma then
               SaveDialog1.FileName :=  Format('Details_Approx_Sigma_konstant_%d_MMax_%d_Fehler_%d_Text_%s.det'
                      , [Const_Value_Approx, Var_Max_Approx, ApproxError, TextSizeToFilename(TextSize_Approx) ])
            else
               SaveDialog1.FileName :=  Format('Details_Approx_M_konstant_%d_SigmaMax_%d_Fehler_%d_Text_%s.det'
                      , [Const_Value_Approx, Var_Max_Approx, ApproxError, TextSizeToFilename(TextSize_Approx) ]);
            if SaveDialog1.Execute then
              ApproxSave(SaveDialog1.Filename);
        end;
  end;
end;

procedure TDetailForm.BtnLoadClick(Sender: TObject);
var Stream: TMemoryStream;
    h, m, v, c, len, e, p: Integer;
    alg: SearchAlgorithms;
    Multialg: MultiSearchAlgorithms;
    Approxalg: ApproxSearchAlgorithms;
    loopI, loopL, LoopMax: Integer;

    CORRECT_STUPID_INTEGER_OVERFLOW: Integer;
    { Die Zeiteinheit, in der ich zuerst gemessen, ist Nanosekunden.
      Bei 2 Sekunden kommt dabei ein Integer-berlauf zustande, was einige Algorithmen
      bei vielen Mustern und langen Texten auch erreichen.
      Um die alten Dateien nicht alle konvertieren zu mssen, lse ich das hier so.
      Die neuen Dateien haben als einheit 100ns - der Overflow tritt dann bei 200 Sekunden auf,
      also bei 3 Minuten nochwas. Das sollte reichen.

    }
begin
  Det_GoOn := False;
  if OpenDialog1.Execute then
  begin
    Stream := TMemoryStream.Create;
    Stream.LoadFromFile(OpenDialog1.FileName);
    Stream.Read(h, SizeOf(Integer));

    If h < 100 then     // d.h. alte Dateien
      CORRECT_STUPID_INTEGER_OVERFLOW := 100
    else
      CORRECT_STUPID_INTEGER_OVERFLOW := 1;

    h := h mod 100;

    case h of
      0: begin
          Stream.Read(m, SizeOf(Integer));
          Stream.Read(v, SizeOf(Integer));
          Stream.Read(c, SizeOf(Integer));
          Stream.Read(len, SizeOf(Integer));
          InitSimpleStats(m,v,c,len);
          for alg := low(SearchAlgorithms) to high(SearchAlgorithms) do
          begin
            for loopI := 1 to Var_Max_Simple do
            begin
                Stream.Read( LoopMax, SizeOf(Integer));
                for loopL := 1 to LoopMax do
                begin
                    Stream.Read(h, SizeOf(Integer));
                    h := Round(h/CORRECT_STUPID_INTEGER_OVERFLOW);
                    TimesListArray[loopI,alg].Add(Pointer(h));
                end;
                if TimesListArray[loopI,alg].Count > 0 then
                  Average[loopI,alg] := GetMedian(TimesListArray[loopI,alg]);
            end;
          end;
          PCSuchModus.ActivePageIndex := 0;
          DrawSimpleDetails;
      end;
      1: begin
          Stream.Read(m, SizeOf(Integer));
          Stream.Read(v, SizeOf(Integer));
          Stream.Read(c, SizeOf(Integer));
          Stream.Read(len, SizeOf(Integer));
          Stream.Read(p, SizeOf(Integer));
          //Showmessage (inttostr(p));
          //exit;
          InitMultiStats(m,v,c,p,len);
          for Multialg := low(MultiSearchAlgorithms) to high(MultiSearchAlgorithms) do
          begin
            for loopI := 1 to Var_Max_Multi do
            begin
                Stream.Read( LoopMax, SizeOf(Integer));
                for loopL := 1 to LoopMax do
                begin
                    Stream.Read(h, SizeOf(Integer));
                    h := Round(h/CORRECT_STUPID_INTEGER_OVERFLOW);
                    MultiTimesListArray[loopI,Multialg].Add(Pointer(h));
                end;
                if MultiTimesListArray[loopI,Multialg].Count > 0 then
                  MultiAverage[loopI,Multialg] := GetMedian(MultiTimesListArray[loopI,Multialg]);
            end;
          end;
          PCSuchModus.ActivePageIndex := 1;
          DrawMultiDetails;
      end;
      2: begin
          Stream.Read(m, SizeOf(Integer));
          Stream.Read(v, SizeOf(Integer));
          Stream.Read(c, SizeOf(Integer));
          Stream.Read(len, SizeOf(Integer));
          Stream.Read(e, SizeOf(Integer));
          InitApproxStats(m,v,c,e,len);
          for Approxalg := low(ApproxSearchAlgorithms) to high(ApproxSearchAlgorithms) do
          begin
            for loopI := 1 to Var_Max_Approx do
            begin
                Stream.Read( LoopMax, SizeOf(Integer));
                for loopL := 1 to LoopMax do
                begin
                    Stream.Read(h, SizeOf(Integer));
                    h := Round(h/CORRECT_STUPID_INTEGER_OVERFLOW);
                    ApproxTimesListArray[loopI,Approxalg].Add(Pointer(h));
                end;
                if ApproxTimesListArray[loopI,Approxalg].Count > 0 then
                  ApproxAverage[loopI,Approxalg] := GetMedian(ApproxTimesListArray[loopI,Approxalg]);
            end;
          end;
          PCSuchModus.ActivePageIndex := 2;
          DrawApproxDetails;
      end;
    end;
    Stream.Free;
  end;
end;

procedure TDetailForm.BtnSaveImageClick(Sender: TObject);
begin
  case PCSuchModus.ActivePageIndex of
        0: begin
            If Messmodus_Simple = MM_ConstantSigma then
               SaveImageDialog.FileName :=  Format('Details_Einfach_Sigma_konstant_%d_MMax_%d_Text_%s.bmp'
                      , [Const_Value_Simple, Var_Max_Simple, TextSizeToFilename(TextSize_Simple) ])
            else
               SaveImageDialog.FileName :=  Format('Details_Einfach_M_konstant_%d_SigmaMax_%d_Text_%s.bmp'
                      , [Const_Value_Simple, Var_Max_Simple, TextSizeToFilename(TextSize_Simple) ]);
        end;
        1: begin
            If Messmodus_Multi = MM_ConstantSigma then
               SaveImageDialog.FileName :=  Format('Details_Multi_Sigma_konstant_%d_MMax_%d_Anzahl_%d_Text_%s.bmp'
                      , [Const_Value_Multi, Var_Max_Multi, MultiCount, TextSizeToFilename(TextSize_Multi) ])
            else
               SaveImageDialog.FileName :=  Format('Details_Multi_M_konstant_%d_SigmaMax_%d_Anzahl_%d_Text_%s.bmp'
                      , [Const_Value_Multi, Var_Max_Multi, MultiCount ,TextSizeToFilename(TextSize_Multi) ]);
        end;
        2: begin
            If Messmodus_Approx = MM_ConstantSigma then
               SaveImageDialog.FileName :=  Format('Details_Approx_Sigma_konstant_%d_MMax_%d_Fehler_%d_Text_%s.bmp'
                      , [Const_Value_Approx, Var_Max_Approx, ApproxError, TextSizeToFilename(TextSize_Approx) ])
            else
               SaveImageDialog.FileName :=  Format('Details_Approx_M_konstant_%d_SigmaMax_%d_Fehler_%d_Text_%s.bmp'
                      , [Const_Value_Approx, Var_Max_Approx, ApproxError, TextSizeToFilename(TextSize_Approx) ]);
        end;
  end;
  if SaveImageDialog.Execute then
    Image1.Picture.Bitmap.SaveToFile(SaveImageDialog.Filename);

end;

end.
